import pandas as pd   
import pickle
from decision_company import read_csv_file, logical_and, filter_by_condition

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create conditions  
condition1 = high_credit_long_duration['age'] >= 25  
condition2 = high_credit_long_duration['age'] <= 55  
  
# Perform logical AND operation  
final_condition = logical_and(condition1, condition2)  
  
# Filter the clients aged between 25 and 55  
clients_25_to_55 = filter_by_condition(high_credit_long_duration, final_condition)  

print(f"clients_25_to_55: {clients_25_to_55}")  
pickle.dump(clients_25_to_55, open("./ref_result/clients_25_to_55.pkl","wb"))

  